/* <nagf04.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f04 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2152 (Feb 1998).
 * Mark 6 revised. IER-3035 (July 2000).
 */
#ifndef NAGF04
#define NAGF04

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL f04aac(double *a, Integer tda, double *b, Integer tdb, Integer n,
                     Integer m, double *c, Integer tdc, NagError *fail);
  //Cheney change Complex to complex
  /*extern NAG_DLL_EXPIMP void NAG_CALL f04adc(Integer n, Integer nrhs, Complex *a, Integer tda, Complex *b,
                         Integer tdb, Complex *x, Integer tdx, NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f04adc(Integer n, Integer nrhs, complex *a, Integer tda, complex *b,
                         Integer tdb, complex *x, Integer tdx, NagError *fail);
  extern void f04aec(Integer n, Integer m, double *a, Integer tda, double *b,
                     Integer tdb, double *c, Integer tdc, double *aa, Integer tdaa,
                     double *bb, Integer tdbb, NagError *fail);
  extern void f04afc(Integer n, Integer nrhs, double *a, Integer tda, double *p,
                     double *b, Integer tdb,  double *x, Integer tdx, double *bb,
                     Integer tdbb, Integer *k, NagError *fail);
  extern void f04aff_f(Integer n, Integer ir, double a[], Integer ia,
                       double p[], const double b[], Integer ib, double eps,
                       double x[], Integer ix, double bb[], Integer ibb,
                       Integer *l, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL f04agc(Integer n, Integer nrhs, double *a, Integer tda, double *p, 
                                             double *b, Integer tdb, double *x, Integer tdx, NagError *fail);
  extern void f04agf_f(Integer n, Integer ir, double a[], Integer ia,
                       double p[], const double b[], Integer ib, double x[],
                       Integer ix);
  extern void f04ahc(Integer n, Integer nrhs, double *a, Integer tda,
                     double *aa, Integer tdaa, Integer *pivot, double *b,
                     Integer tdb, double *x, Integer tdx,
                     double *bb, Integer tdbb, Integer *k, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f04ajc(Integer n, Integer nrhs, double *a, 
                                             Integer tda, Integer *pivot, double *b, Integer tdb, NagError *fail);
  extern void f04ajf_f(Integer n, Integer ir, const double a[], Integer ia,
                       const double p[], double b[], Integer ib);
  //Cheney change Complex to complex
  /*extern NAG_DLL_EXPIMP void NAG_CALL f04akc(Integer n, Integer nrhs, Complex *a, Integer tda, Integer *pivot,
                                             Complex *b, Integer tdb, NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f04akc(Integer n, Integer nrhs, complex *a, Integer tda, Integer *pivot,
                                             complex *b, Integer tdb, NagError *fail);
  extern void f04aqc(Integer n, double rl[], double d[],
                     double b[], double x[]);
  extern void f04aqz(Integer n, Integer m,  double rl[], double d[],
                     double b[], double x[]);
  extern NAG_DLL_EXPIMP void NAG_CALL f04arc(Integer n, double *a, Integer tda, double *b, 
                                             double *x, NagError *fail);
  extern void f04asc(double *a, Integer tda, double *b, Integer n, double *c,
                     double *wk1, double *wk2, NagError *fail);
  extern void f04asf_f(double a[], Integer ia, const double b[], Integer n,
                       double c[], double wk1[], double wk2[], Integer *ifail);
  //Cheney change Complex to complex
  /*extern NAG_DLL_EXPIMP void NAG_CALL f04awc(Integer n, Integer nrhs, Complex *a, Integer tda, double *p,
                                             Complex *b, Integer tdb, Complex *x, Integer tdx, NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f04awc(Integer n, Integer nrhs, complex *a, Integer tda, double *p,
                                             complex *b, Integer tdb, complex *x, Integer tdx, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f04jac(Integer m, Integer n,  double a[],  Integer tda,
                     double b[], double tol, double *sigma,
                     Integer *irank, NagError *fail);
  extern void f04jay(Integer n, Integer rank, double sv[],
                     double b[], double pt[], Integer tdpt, double x[],
                     double work[]);
  extern void f04jaz(Integer m, Integer n, Integer rank, double sv[],
                     double b[], double pt[], Integer tdpt,
                     double x[], double *sigma, double work[]);
  extern NAG_DLL_EXPIMP void NAG_CALL f04jdc(Integer m, Integer n,  double a[],  Integer tda,
                     double b[], double tol, double *sigma,
                     Integer *irank, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f04jgc(Integer m, Integer n,  double a[],  Integer tda,
                     double b[], double tol,  Boolean *svd,
                     double *sigma,  Integer *irank,  double comm[],
                     Integer lcomm, NagError *fail);
  extern double f04jgr_f(Integer n, const double a[], Integer nra, double work[]);
  extern double f04jgr(Integer n, double *a, Integer nra, double *work,
                       int *localerror);
  extern double f04jgs(Integer n, double *a, Integer tda, int *localerror);
  extern double f04jgs_f(Integer n, const double a[], Integer nra);
  extern void f04jgt_f(Integer n, const double x[], double *scale, double *sumsq,
                       double tiny, Boolean undflw);
  extern void f04jgt(Integer n, double *x, double *scale, double *sumsq, double tiny,
                     Boolean undflw);
  extern double f04jgu_f(double scale, double sumsq, double big);
  extern double f04jgu(double scale, double sumsq, double big);
  extern double f04jgv(Integer n, double *x, double tiny, double big);
  extern double f04jgw(Integer n, double x[]);
  extern Boolean f04jgx_f(double a, double b, double small1);
  extern Boolean f04jgx(double a, double b, double small1);
  extern void f04jgy_f(Integer n, const double a[], Integer nra, const double b[],
                       double x[], Integer *ifail);
  extern void f04jgy(Integer n, double *a, Integer tda, double *b, double *x,
                     Integer *failinfo, int *localerror);
  extern void f04jgz(Integer m, Integer n, Boolean *svd, Integer rank,
                     double b[], double a[], Integer tda, double sv[],
                     double x[], double *sigma, double work[], Integer *ierr);
  extern void f04lef(Integer job, Integer n,  double a[], double b[],
                     double c[], double d[],  Integer in[],  double y[],
                     double *tol,  Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL f04mcc(Nag_SolveSystem selct, Integer n, Integer nrhs, double *al, Integer lal, 
                                             double *d, Integer *row, double *b, Integer tdb, double *x, 
                                             Integer tdx, NagError *fail);
  extern void f04mcv(Integer n1, Integer n2, double *u, Integer iu1, Integer iu2, 
                     Integer lu, double scale, double *v, Integer iv1, Integer iv2,
                     Integer lv);
  extern void f04mcw(Integer n,double *l,Integer ll,Integer *nrow,Integer p,
                     double *b,Integer ib1,Integer ib2,Integer lb,double *x,
                     Integer ix1,Integer ix2,Integer lx);
  extern void f04mcx(Integer n, double *l, Integer ll, Integer *nrow, Integer p,
                     double *b, Integer ib1, Integer ib2, Integer lb, double *x,
                     Integer ix1, Integer ix2, Integer lx);
  extern void f04mcy(Integer n, double *d, Integer p, double *b, Integer ib1,
                     Integer ib2, Integer lb, double *x, Integer ix1, Integer ix2, 
                     Integer lx);
  extern void f04mcz(Integer n, double *l, Integer ll, double *d, Integer *nrow,
                     Integer p, double *b, Integer ib1, Integer ib2, Integer lb,
                     Nag_SolveSystem iselct, double *x, Integer ix1, Integer ix2, Integer lx);
  extern void f04yac(Integer job, Integer p, double sigma, double a[],
                     Integer tda, Boolean svd, Integer rank, double sv[],
                     double cj[], NagError *fail);
  extern void f04yay(Integer job, Integer n, double t[], Integer tdt,
                     double b[], Integer *ierror);

  extern void f04ycf_c (Integer * icase, Integer n, double x[], double * estnrm,
			double work[], Integer iwork[], Nag_f04ycf_save *f04ycf_save, Integer * ifail);
  
  extern void f04ycf_f (Integer * icase, Integer n, double x[], double * estnrm,
			double work[], Integer iwork[], Integer * ifail);
  
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF04 */
